// 内容脚本 - 在educode.cc页面中运行

(function() {
  'use strict';

  console.log('访问修复小插件已加载');

  // 检查是否在目标网站
  if (!window.location.href.includes('educode.cc')) {
    return;
  }

  // 重写fetch函数以修改请求头
  const originalFetch = window.fetch;
  window.fetch = function(url, options = {}) {
    if (url.includes('img.wkcoding.com')) {
      console.log('修复图片请求:', url);

      // 修改请求头
      const modifiedOptions = {
        ...options,
        headers: {
          ...options.headers,
          'sec-fetch-dest': 'image',
          'sec-fetch-mode': 'no-cors',
          'sec-fetch-site': 'cross-site'
        }
      };

      // 移除referer
      delete modifiedOptions.headers.referer;
      delete modifiedOptions.headers.origin;

      return originalFetch(url, modifiedOptions);
    }
    return originalFetch(url, options);
  };

  // 重写XMLHttpRequest
  const originalXHROpen = XMLHttpRequest.prototype.open;
  XMLHttpRequest.prototype.open = function(method, url, async, user, password) {
    if (url.includes('img.wkcoding.com')) {
      this.addEventListener('setrequestheader', function(e) {
        if (e.detail.header.toLowerCase() === 'referer' ||
            e.detail.header.toLowerCase() === 'origin') {
          e.preventDefault();
        }
      });
    }
    originalXHROpen.call(this, method, url, async, user, password);
  };

  // 静默运行，不显示任何提示
  console.log('访问修复小插件已静默启用');

})();