// 访问修复小插件 v6.1 - 纯Manifest V3版本
console.log('[访问修复小插件 v6.1] Service Worker 启动');

// 插件安装时的初始化
chrome.runtime.onInstalled.addListener(() => {
  console.log('[访问修复小插件 v6.1] 插件已安装');

  // 立即设置头部修改规则
  setupDeclarativeRules();
});

// 设置声明式网络请求规则
async function setupDeclarativeRules() {
  try {
    // 先清除所有现有规则
    const existingRules = await chrome.declarativeNetRequest.getDynamicRules();
    const ruleIdsToRemove = existingRules.map(rule => rule.id);

    if (ruleIdsToRemove.length > 0) {
      await chrome.declarativeNetRequest.updateDynamicRules({
        removeRuleIds: ruleIdsToRemove
      });
      console.log('[访问修复小插件 v6.1] 清除现有规则:', ruleIdsToRemove);
    }

    // 添加新规则
    await chrome.declarativeNetRequest.updateDynamicRules({
      addRules: [
        {
          id: 1,
          priority: 1,
          action: {
            type: "modifyHeaders",
            requestHeaders: [
              {
                header: "origin",
                operation: "remove"
              },
              {
                header: "referer",
                operation: "remove"
              },
              {
                header: "sec-fetch-site",
                operation: "set",
                value: "same-site"
              },
              {
                header: "sec-fetch-mode",
                operation: "set",
                value: "cors"
              }
            ]
          },
          condition: {
            urlFilter: "||img.wkcoding.com",
            resourceTypes: ["main_frame", "sub_frame", "stylesheet", "script", "image", "font", "xmlhttprequest", "other"]
          }
        }
      ]
    });

    console.log('[访问修复小插件 v6.1] DeclarativeNetRequest规则设置完成');
  } catch (error) {
    console.error('[访问修复小插件 v6.1] 设置规则时出错:', error);
  }
}

// 插件图标点击处理
chrome.action.onClicked.addListener((tab) => {
  chrome.tabs.create({
    url: chrome.runtime.getURL('help.html')
  });
});

// 监听标签页更新，用于调试
chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  if (changeInfo.status === 'complete' && tab.url && tab.url.includes('educode.cc')) {
    console.log('[访问修复小插件 v6.1] educode.cc页面加载完成');

    // 向内容脚本发送消息
    chrome.tabs.sendMessage(tabId, {
      type: 'PAGE_LOADED',
      url: tab.url
    }).catch(() => {
      // 忽略内容脚本未加载的错误
    });
  }
});

console.log('[访问修复小插件 v6.1] Service Worker 初始化完成');